#! /bin/sh
ifile=$1
ofile=$2
label=$3
wait=$4

date=`date '+%D %H:%M'`
sm -s << FIN
if ($wait) {xterm_p} else {laser_pp out.ps\n lweight 2}
expand 0.9
da $ifile
read {irho 1 iu 2}
set i=0,dimen(irho)-1,1
set x=i/dimen(irho)
da times
read times 1
da $ofile
read {t 1 rho 2 u 3}
set rholim=rho if (t<times[dimen(times)-1]+0.005) 
set ulim=u if (t<times[dimen(times)-1]+0.005) 
set rholim=rholim concat irho
set ulim=ulim concat iu
sixwin 1
limits 0 1 rholim
box
sixwin 2
limits 0 1 ulim
box
sixwin 1
limits 0 1 rholim
connect x irho
sixwin 2
limits 0 1 ulim
connect x iu
macro plt 1 {
  echo
  set rho1=rho if (abs(t-\$1)<0.005)
  set u1=u if (abs(t-\$1)<0.005)
  sixwin 1
  limits 0 1 rholim
  connect x rho1
  sixwin 2
  limits 0 1 ulim
  connect x u1
}
do i=0,dimen(times)-1 {
    define color (3+\$i)
    ctype \$color
    define time (times[\$i])
    plt \$time 
}
ltype 0
ctype 0
limits 0 10 0 10
sixwin 1
relocate -2.8 5
putlabel 5 \rho
sixwin 2
relocate -2.8 5
putlabel 5 u
expand 0.85
sixwin 3
ullinlbl 9.25 0 t=0
do i=0,dimen(times)-1 {
    define color (3+\$i)
    define time (sprintf('%.3f',times[\$i]))
    define y (8.5-0.75*\$i)
    ulclinlbl \$y 0 \$color \$time
}
ctype 0
sixlabel 12 $label
#putdate "$date"
if ($wait) {!sleep $wait} else {hardcopy}
FIN
